<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:linux-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is the modified version of the existing library unixServiceChecks.xsl.
        
        This library works fine for the below check logic:
        
        <criteria operator="OR">
            <criterion comment="Verify the existence of root account" negate="true" test_ref="oval:com.mcafee.oval:tst:231043"/> - User existence test
            <criterion comment="Verify the group owner of the root account" test_ref="oval:com.mcafee.oval:tst:231044"/> - User GID test
        </criteria>
        
        Example def if : oval:com.mcafee.oval:def:230890
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
  
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        
        <xsl:variable name="extVar_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable/@id"/>
        <xsl:variable name="expectedGroupID" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test/oval-res:tested_variable[@variable_id=$extVar_id]/text()"/>
        
        <xsl:variable name="actualGroupID">
              <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:password_item/unix-sc:group_id/text()"/>
        </xsl:variable>
        
        <xsl:variable name="userName">
            <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:password_item/unix-sc:username/text()"/>
        </xsl:variable>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$result='true' and $result1='true'">
                    <xsl:text>com.mcafee.pa.msg.userStatus</xsl:text>        
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>com.mcafee.pa.msg.userGIDStatus</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>                
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expected_gid</xsl:attribute>
                    <xsl:value-of select="$expectedGroupID"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_gid</xsl:attribute>
                    <xsl:value-of select="$actualGroupID"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">username</xsl:attribute>
                    <xsl:value-of select="$userName"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>