<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
	<!-- commented the following code "<xsl:value-of select="$p"/>" and added "READ" text for value "C" -->
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Mar 4, 2010</xd:p>
            <xd:p><xd:b>Author:</xd:b> dwhitehurst</xd:p>
            <xd:p></xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"></xsl:param>
        <xsl:variable name="OvalResultDefinitions"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
        <xsl:variable name="defResult" select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:if test="$defResult='false'">
            <xsl:call-template name="mfe-regkeyPermissions">
                <xsl:with-param name="definitionId" select="$definitionId"></xsl:with-param>
            </xsl:call-template> 
            
        </xsl:if>
    </xsl:template>   
    <xsl:template name="mfe-regkeyPermissions">
        <xsl:param name="definitionId"></xsl:param>
        
        <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definitionId}">
            <xsl:variable name="OvalResultTests"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            <xsl:variable name="OvalResultItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
            <xsl:variable name="OvalResultDefinitions"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="OvalResultTests1"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            <xsl:variable name="test1Id" select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=1]/@test_ref"/>
            <xsl:variable name="test2Id" select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=2]/@test_ref"/>
            <xsl:variable name="object1Id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/win-def:regkeyeffectiverights53_test[@id=$test1Id]/win-def:object/@object_ref"></xsl:variable>
            <xsl:variable name="object2Id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/win-def:regkeyeffectiverights53_test[@id=$test2Id]/win-def:object/@object_ref"></xsl:variable>
            <xsl:variable name="collectedObject2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$object2Id]"></xsl:variable>
            
            <xsl:variable name="itemId" select="$collectedObject2/oval-sc:reference/@item_ref"></xsl:variable>
            <xsl:variable name="ferItem" select="$OvalResultItems/*[@id=$itemId]"></xsl:variable>
            <xsl:variable name="hive" select="$ferItem/win-sc:hive"></xsl:variable>
            <xsl:variable name="key" select="$ferItem/win-sc:key"></xsl:variable>
            <xsl:variable name="fullKeyname">
                <xsl:value-of select="$hive"/>
                <xsl:text>\</xsl:text>
                <xsl:value-of select="$key"/>
            </xsl:variable>
            
            <xsl:variable name="testId" select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=1 and @result = 'false']/@test_ref"></xsl:variable>
            
            <!-- Check for regkey doesn't exist (creiterion 1 fails and no tested item  -->
            <xsl:variable name="test" select="$OvalResultTests/oval-res:test[@test_id=$testId]"/>
            <xsl:variable name="testedItem" select="$test/oval-res:tested_item"></xsl:variable>
            
            <xsl:if test="not($testedItem)">
                <xsl:variable name="msgid">com.mcafee.pa.msg.regkeydoesnotexist</xsl:variable>
                <finding messageId="{$msgid}" isViolation="true"  xmlns="http://results.pa.mcafee.com/findings/5.2" >
                    <instanceValue key="regkey"><xsl:value-of select="$fullKeyname"/></instanceValue>
                </finding>
            </xsl:if>
            
            <xsl:if test="$testedItem">
                <!-- check for accounts that have rights and shouldn't -->
                <xsl:call-template name="mfe-shouldhavenorights">
                    <xsl:with-param name="testId" select="$testId"></xsl:with-param>
                    <xsl:with-param name="regkeyname" select="$fullKeyname"></xsl:with-param>
                </xsl:call-template>
                
                <!-- check for accounts that don't have expected rights -->
                <xsl:variable name="criterions" select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()>1 and @result = 'false']"></xsl:variable>
                <xsl:call-template name="mfe-notExpectedRights">
                    <xsl:with-param name="criterions" select="$criterions"></xsl:with-param>
                    <xsl:with-param name="regkeyname" select="$fullKeyname"></xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </findings>
    </xsl:template>
    
    <xsl:template name="mfe-notExpectedRights">
        <xsl:param name="criterions"/>
        <xsl:param name="regkeyname"/>
        <xsl:variable name="OvalResultTests"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="OvalResultItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
        <xsl:for-each select="$criterions">
            <xsl:variable name="testId" select="./@test_ref"/>
            <xsl:variable name="stateId" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/*[@id=$testId]/win-def:state/@state_ref"></xsl:variable>
            <xsl:variable name="expectedState" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/*[@id=$stateId]"></xsl:variable>
            <xsl:variable name="expectedPerms">
                <xsl:call-template name="mfe-getPermissionString">
                    <xsl:with-param name="ferItem" select="$expectedState"></xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="test" select="$OvalResultTests/oval-res:test[@test_id=$testId]"/>
            <xsl:variable name="testedItemId" select="$test/oval-res:tested_item/@item_id"/>
            <xsl:variable name="item" select="$OvalResultItems/win-sc:regkeyeffectiverights_item[@id=$testedItemId]"></xsl:variable>
            <xsl:variable name="p1">
                <xsl:call-template name="mfe-getPermissionString">
                    <xsl:with-param name="ferItem" select="$item"></xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="account" select="$item/win-sc:trustee_name"/>
            
            <finding messageId="com.mcafee.pa.msg.winregkeyrightsviolation" isViolation="true"  xmlns="http://results.pa.mcafee.com/findings/5.2" >
                <instanceValue key="account"><xsl:value-of select="$account"/></instanceValue>
                <instanceValue key="regkey"><xsl:value-of select="$regkeyname"/></instanceValue>
                <instanceValue key="permissions"><xsl:value-of select="$expectedPerms"/></instanceValue>
                <actualValue key="permissions"><xsl:value-of select="$p1"/></actualValue>
            </finding>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="mfe-shouldHaveFullRights">
        
    </xsl:template>
    <xsl:template name="mfe-shouldhavenorights">
        <xsl:param name="testId"></xsl:param>
        <xsl:param name="regkeyname" ></xsl:param>
        <xsl:variable name="OvalResultTests"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="OvalResultItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
        <xsl:variable name="test" select="$OvalResultTests/oval-res:test[@test_id=$testId]"/>
        <xsl:for-each select="$test/oval-res:tested_item[@result='false']">
            <xsl:variable name="itemId" select="@item_id"></xsl:variable>
            <xsl:variable name="item" select="$OvalResultItems/*[@id=$itemId]"></xsl:variable>
            <xsl:variable name="permissionString">
                <xsl:call-template name="mfe-getPermissionString">
                    <xsl:with-param name="ferItem" select="$item"></xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="account" select="$item/win-sc:trustee_name"/>
            <finding messageId="com.mcafee.pa.msg.winregkeynonerightsviolation" isViolation="true"  xmlns="http://results.pa.mcafee.com/findings/5.2"  >
                <instanceValue key="account"><xsl:value-of select="$account"/></instanceValue>
                <instanceValue key="regkey"><xsl:value-of select="$regkeyname"/></instanceValue>
                <actualValue key="permissions"><xsl:value-of select="$permissionString"/></actualValue>
            </finding>
            
        </xsl:for-each>
        
    </xsl:template >
    <xsl:template name="mfe-getPermissionString">
        <xsl:param name="ferItem"></xsl:param>
        <xsl:variable name="p">
            <xsl:call-template name="mfe-getPermissionString2">
                <xsl:with-param name="ferItem" select="$ferItem"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$p"/>
        <xsl:choose>
            <xsl:when test="$p = 'QVSENDC'">
                <xsl:text>(Read,Write,Delete)</xsl:text>
            </xsl:when>
            <xsl:when test="'QENC' = $p" >
                <xsl:text>(Read)</xsl:text>
            </xsl:when>
            <xsl:when test="'QVSENLDPOC' = $p">
                <xsl:text>(Full Control)</xsl:text>
            </xsl:when>
            <xsl:when test="'D' = $p">
                <xsl:text>(Delete)</xsl:text>
            </xsl:when>
            <xsl:when test="'C' = $p">
                <xsl:text>(Read)</xsl:text>
            </xsl:when>
            <xsl:when test="'VSC' = $p">
                <xsl:text>(Write)</xsl:text>
            </xsl:when>
            <xsl:when test="'QVSENC' = $p">
                <xsl:text>(Read,Write)</xsl:text>
            </xsl:when>
            <xsl:when test="'' = $p">
                <xsl:text>no permissions</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="mfe-getPermissionString2">
        <xsl:param name="ferItem"></xsl:param>
        <xsl:text></xsl:text>
        <xsl:if test="1 = $ferItem/*[local-name()='key_query_value']">
            <xsl:value-of select="'Q'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='key_set_value']">
            <xsl:value-of select="'V'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='key_create_sub_key']">
            <xsl:value-of select="'S'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='key_enumerate_sub_keys']">
            <xsl:value-of select="'E'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='key_notify']">
            <xsl:value-of select="'N'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='key_create_link']">
            <xsl:value-of select="'L'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_delete']">
            <xsl:value-of select="'D'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_write_dac']">
            <xsl:value-of select="'P'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_write_owner']">
            <xsl:value-of select="'O'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_read_control']">
            <xsl:value-of select="'C'"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
