﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: SCAPWinAdobeFlasPlayer_SCAP.xsl         DATE: 15th Aug, 2012     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: SCAPWinAdobeFlasPlayer_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR Adobe FLash Player modified check logic for verifying patch updates for browser plugin and ActiveX -->

    <!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Software name and patch number are extracted from the title of the check.
            2. Following are the test cases which are taken into consideration for the logic:-
            3. Final result is nagated since it is patch check
    ______________________________________________________________________________________________________________________________________________________________________
       Test Case  Final Result        Patch Status                     Is Violation        Message ID
    ______________________________________________________________________________________________________________________________________________________________________
    
      Result1       false     	              Patch installed                  FALSE               com.mcafee.pa.msg.FlashSecUpdInstalled_SCAP
      Result2       false     	              Patch not applicable        FALSE               com.mcafee.pa.msg.FlashNotInstalled_SCAP
      Result3       true	              Patch not installed            TRUE                com.mcafee.pa.msg.FlashSecUpdActiveXPluginMissing_SCAP (both ActiveX and Browser plugin updates are missing)
      Result4       true	              Patch not installed            TRUE                com.mcafee.pa.msg.FlashSecUpdPluginMissing_SCAP (Browser plugin update is missing)
      Result5       true	              Patch not installed            TRUE                com.mcafee.pa.msg.FlashSecUpdActiveXPluginMissing_SCAP (ActiveX update is missing)
       ______________________________________________________________________________________________________________________________________________________________________    
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="definitionIdWithoutCommon">
            <xsl:choose>   
                <xsl:when test="contains($definitionId, '.common' )">
                    <xsl:value-of select="concat(substring-before($definitionId, '.common'), substring-after($definitionId, '.common'))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$definitionId"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract application name and patch number from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionIdWithoutCommon ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        <xsl:variable name="software">
            <xsl:if test="contains($title, 'Security Update')">
                <xsl:value-of select="substring-before($title, 'Security Update' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="patchNumber">
            <xsl:if test="contains($title, 'for')">
                <xsl:value-of select="substring-before(substring-after($title, 'Security Update' ), ' for' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="resultCriterion1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="resultCriterion2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="resultCriterion3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="resultCriterion4"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criterion[4]/@result"/>
        
        <xsl:variable name="resultCriteria1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criteria[1]/@result"/>
        <xsl:variable name="resultCriteria2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criteria[2]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if final result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="($resultCriteria1 = 'true' and $resultCriteria2 = 'true')">
                            <xsl:text>com.mcafee.pa.msg.FlashSecUpdActiveXPluginMissing_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="($resultCriteria1 = 'true' and ($resultCriteria2 = 'false' and $resultCriterion3='false' and $resultCriterion4='true'))">
                            <xsl:text>com.mcafee.pa.msg.FlashSecUpdPluginMissing_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="($resultCriteria2 = 'true' and ($resultCriteria1 = 'false' and $resultCriterion1='false' and $resultCriterion2='true'))">
                            <xsl:text>com.mcafee.pa.msg.FlashSecUpdActiveXMissing_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="($resultCriteria1 = 'true' and ($resultCriteria2 = 'false' and $resultCriterion3='true' and $resultCriterion4='false'))">
                            <xsl:text>com.mcafee.pa.msg.FlashSecUpdPluginMissing_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="($resultCriteria2 = 'true' and ($resultCriteria1 = 'false' and $resultCriterion1='true' and $resultCriterion2='false'))">
                            <xsl:text>com.mcafee.pa.msg.FlashSecUpdActiveXMissing_SCAP</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if final result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="(($resultCriteria1 = 'false' and $resultCriterion1='true' and $resultCriterion2='false') and ($resultCriteria2 = 'false' and $resultCriterion3='true' and $resultCriterion4='false'))">
                            <xsl:text>com.mcafee.pa.msg.FlashSecUpdInstalled_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="(($resultCriteria1 = 'false' and $resultCriterion1='true' and $resultCriterion2='false') and ($resultCriteria2 = 'false' and $resultCriterion3='false' and $resultCriterion4='true'))">
                            <xsl:text>com.mcafee.pa.msg.FlashPluginSecUpdInstalled_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="(($resultCriteria1 = 'false' and $resultCriterion1='false' and $resultCriterion2='true') and ($resultCriteria2 = 'false' and $resultCriterion3='true' and $resultCriterion4='false'))">
                            <xsl:text>com.mcafee.pa.msg.FlashActiveXSecUpdInstalled_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="($resultCriterion1 = 'false' and $resultCriterion3='false')">
                            <xsl:text>com.mcafee.pa.msg.FlashNotInstalled_SCAP</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionIdWithoutCommon}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="software">
                    <xsl:value-of select="$software"/>                                                    
                </instanceValue>
                <instanceValue key="SecUpdate">
                    <xsl:value-of select="$patchNumber"/>                                                    
                </instanceValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
