<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:linux-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc linux-sc linux-def">
    
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This XSLT library is to address the auto-generated Cent OS 5 & 6 patch content.
            This library works for the below sample logic:
            
            <criteria comment="Cent OS Patches" operator="OR">
                <criterion negate="true" test_ref="oval:com.mcafee.oval.gen:tst:11111"/>  - rpminfo_test (could be single as well)
                <criterion negate="true" test_ref="oval:com.mcafee.oval.gen:tst:22222"/> - rpminfo_test
                <criterion negate="true" test_ref="oval:com.mcafee.oval.gen:tst:33333"/> - rpminfo_test
            </criteria>
            
     Test cases:
         1. When final result is true, one or more rpm packages are not patched.
         2. When final result is false, there could be 2 cases:
                     * one or more rpm packages exist and are patched.
                     *  none of the rpm packages.
                     * combination of package not existing and package exist and also patched.
                     
   Please note that, this library works fine when there is a common rpm state for all the packages and when there are multiple rpm states for multiple packages.
    -->
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:variable name="definitionTitle" select=" substring-after(/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition/oval-def:metadata/oval-def:title, 'Patches for ')"/>
        
        <xsl:variable name="packageListUptoDate">
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/linux-def:rpminfo_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>rpmTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='rpmTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'true']">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="rpmTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/linux-sc:rpminfo_item[@id=$itemRef]" />
                    <xsl:value-of select="$rpmTestItem/linux-sc:name/text()"/>
                    <xsl:text>   </xsl:text>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="packageListDoesNotExist">
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/linux-def:rpminfo_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>rpmTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='rpmTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'not evaluated']">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="rpmTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/linux-sc:rpminfo_item[@id=$itemRef]" />
                    <xsl:value-of select="$rpmTestItem/linux-sc:name/text()"/>
                    <xsl:text>   </xsl:text>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="packagesNotPatched">
            <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                <xsl:if test="@result='true'">
                    <xsl:variable name="testID" select="@test_ref"/>
                    <xsl:variable name="objID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:rpminfo_test[@id=$testID]/linux-def:object/@object_ref"/>
                    <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/linux-def:rpminfo_object[@id=$objID]/linux-def:name/text()"/>
                    <xsl:text>  </xsl:text>
                </xsl:if> 
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="States"
            select="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state)"/>
   
        <xsl:variable name="packagesListNotPatched">
            <xsl:choose>
                <xsl:when test="$States='1.0'">
                    <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                        <xsl:if test="@result='true'">
                            <xsl:variable name="testID" select="@test_ref"/>
                            <xsl:variable name="objID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:rpminfo_test[@id=$testID]/linux-def:object/@object_ref"/>
                            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/linux-def:rpminfo_object[@id=$objID]/linux-def:name/text()"/>
                            <xsl:text>  </xsl:text>
                        </xsl:if> 
                    </xsl:for-each>        
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                        <xsl:if test="@result='true'">
                            <xsl:variable name="testID" select="@test_ref"/>
                            <xsl:variable name="objID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:rpminfo_test[@id=$testID]/linux-def:object/@object_ref"/>
                            <xsl:variable name="rpmName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/linux-def:rpminfo_object[@id=$objID]/linux-def:name/text()"/>
                            <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:rpminfo_test[@id=$testID]/linux-def:state/@state_ref"/>
                            <xsl:variable name="rpmVer" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state[@id=$steID]/linux-def:version/text()"/>
                            <xsl:variable name="rpmRel" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state[@id=$steID]/linux-def:release/text()"/>
                            <xsl:variable name="rpmVersion">
                                <xsl:choose>
                                    <xsl:when test="$rpmVer!='' and $rpmRel!=''">
                                        <xsl:value-of select="concat($rpmVer,'-',$rpmRel)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$rpmVer"/>
                                    </xsl:otherwise>
                                </xsl:choose>    
                            </xsl:variable>
                           <xsl:value-of select="concat($rpmName,' : ',$rpmVersion,'  ')"/>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:variable> 
       <!--  
        <xsl:variable name="packageList">
            <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                 <xsl:variable name="testID" select="@test_ref"/>
                 <xsl:variable name="objID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:rpminfo_test[@id=$testID]/linux-def:object/@object_ref"/>
                 <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/linux-def:rpminfo_object[@id=$objID]/linux-def:name/text()"/>
                 <xsl:text>  </xsl:text>
            </xsl:for-each>
        </xsl:variable>
       -->
        
        <xsl:variable name="packageVersion">
               <xsl:variable name="testID" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion[1]/@test_ref"/>
               <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:rpminfo_test[@id=$testID]/linux-def:state/@state_ref"/>
            <xsl:variable name="pkgVer" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state[@id=$steID]/linux-def:version/text()"/>
            <xsl:variable name="pkgRelVer" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state[@id=$steID]/linux-def:release/text()"/>
            <xsl:choose>
                <xsl:when test="$pkgRelVer!='' and $pkgVer!=''">
                    <xsl:value-of select=" concat(/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state[@id=$steID]/linux-def:version/text(),'-',/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/linux-def:rpminfo_state[@id=$steID]/linux-def:release/text())"/>        
                </xsl:when>
                <xsl:otherwise>
                        <xsl:value-of select="$pkgVer"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
            <xsl:choose>
                <xsl:when test="$States='1.0'">
                    <xsl:text>com.mcafee.pa.msg.PackageListNotPatched</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>com.mcafee.pa.msg.PackagesNotPatched</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            </xsl:if>  
            
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$packageListUptoDate='' and $packageListDoesNotExist!=''">
                        <xsl:text>com.mcafee.pa.msg.PatchesNotApplicable</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.PackagesUptoDate</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">title</xsl:attribute>
                    <xsl:value-of select="$definitionTitle"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">packageListUptoDate</xsl:attribute>
                    <xsl:value-of select="$packageListUptoDate"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">packageListDoesNotExist</xsl:attribute>
                    <xsl:value-of select="$packageListDoesNotExist"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">packagesListNotPatched</xsl:attribute>
                    <xsl:value-of select="$packagesListNotPatched"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">packagesNotPatched</xsl:attribute>
                    <xsl:value-of select="$packagesNotPatched"/>
                </xsl:element>
                <!-- <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">packageList</xsl:attribute>
                    <xsl:value-of select="$packageList"/>
                </xsl:element> -->
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                        <xsl:attribute name="key">packageVersion</xsl:attribute>
                    <xsl:value-of select="$packageVersion"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>
