<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
                    This XSLT is used for the definition which want to verify whther some registry parameter exist or not.
                    
                    critera (and)
                        extend_definition  : To check the OS requirement  
                        criterion                   : To check the certain registry existance.
                        ....one or more registry test of same type.
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result != 'true' ">
            <xsl:call-template name="winRegistryParameterExistCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winRegistryParameterExistCheck">
        <xsl:param name="definitionId"/>       
        
        <xsl:variable name="exDefinitionId">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition/@definition_ref"/>
        </xsl:variable>
        
        <xsl:variable name="rs_exDefinition">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[ @definition_ref = $exDefinitionId ]/@result"/>
        </xsl:variable>
        
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:variable name="object" select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>                
                
                <xsl:variable name="key" select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                <xsl:variable name="name" select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>
                    
                <xsl:element name="test">
                    <xsl:attribute name="id">
                        <xsl:value-of select="$test"/>
                    </xsl:attribute>
                    <xsl:attribute name="key">
                        <xsl:value-of select="$key"/>
                    </xsl:attribute>
                    <xsl:attribute name="name">
                        <xsl:value-of select="$name"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:for-each>            
            
        </xsl:variable>
  
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">       
            
            <xsl:if test="$rs_exDefinition = 'true' ">
                
                <xsl:for-each select="xalan:nodeset($tests)/*">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="key" select="@key"/>
                    <xsl:variable name="name" select="@name"/>
                    
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                     
                        <xsl:variable name="actualParameterStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when
                                    test="$actualParameterStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.winregistryisnotexist</xsl:text>
                                </xsl:when>
                                <xsl:when
                                    test="$result = 'error' or  $result='not evaluated' ">
                                    <xsl:text>com.mcafee.pa.msg.winregistryreaderror</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>com.mcafee.pa.msg.winregistryisexist</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <finding messageId="{$message_id}" isViolation="true">                                        
                            <instanceValue key="registry">
                                <xsl:value-of  select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>
                            </instanceValue>                                      
                        </finding>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:if>
        </findings>
        
    </xsl:template>
</xsl:stylesheet>