<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
     extend def
     Criterio
          criterion 
          criterion  -> Service status expected is 4
    -->
    
    <xsl:include  href="common.xsl" />
    
    <xsl:template name="getExpectedWinServiceStatus">
            <xsl:param name="test"/>
        
            <xsl:variable name="state">
                <xsl:value-of select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
            </xsl:variable>
        
                <xsl:variable name="startValue">
                    <xsl:value-of select="$States/win-def:registry_state[@id=$state ]/win-def:value"/>
                </xsl:variable>
                
            <xsl:call-template name="getWinServiceStatus">
                <xsl:with-param name="startValue" select="$startValue"/>
             </xsl:call-template>
          
        
    </xsl:template>
    
    <xsl:template name="getWinServiceStatus">
        <xsl:param name="startValue"/>        
        
        <xsl:choose>
            <xsl:when test="$startValue = '4' ">
                <xsl:text>disabled</xsl:text>
            </xsl:when>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="extractExe">
      <xsl:param name="key"/>
      <xsl:param name="length"/>
        <xsl:choose>
            <xsl:when test="$length = '0' ">
                <xsl:text></xsl:text>
            </xsl:when>
            <xsl:when test="substring($key,$length,1) = '\'  ">
                  <xsl:text></xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring($key,$length,1)"/>
                 <xsl:call-template name="extractExe">
                     <xsl:with-param name="key" select="$key"/>
                     <xsl:with-param name="length" select="$length - 1"/>
                 </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' ">
            <xsl:call-template name="winServiceCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winServiceCheck">
        <xsl:param name="definitionId"/>       
        
        
        <xsl:variable name="exDefinitionId">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:extend_definition/@definition_ref"/>
        </xsl:variable>
        
        <xsl:variable name="test1">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criteria/oval-res:criterion[1]/@test_ref "/>
        </xsl:variable>
        
        <xsl:variable name="test2">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criteria/oval-res:criterion[2]/@test_ref "/>
        </xsl:variable>
        
        <!-- Precondition -->
        
        <xsl:variable name="rs_exDefinition">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:extend_definition[ @definition_ref = $exDefinitionId ]/@result"/>
        </xsl:variable>
        

        <xsl:variable name="rs_test">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criteria/@result"/>
        </xsl:variable>
        
        <xsl:variable name="rs_test1">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criteria/oval-res:criterion[1]/@result"/>
        </xsl:variable>
        
        <xsl:variable name="rs_test2">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criteria/oval-res:criterion[2]/@result"/>
        </xsl:variable>
                
        <!--   Service name      -->
        <xsl:variable name="object">            
                <xsl:value-of select="$Tests/win-def:registry_test[@id=$test2]/win-def:object/@object_ref"/>    
        </xsl:variable>
        
        <xsl:variable name="serviceExe">
            <xsl:call-template name="extractExe">
                <xsl:with-param name="key" select="$Objects/win-def:registry_object[@id=$object ]/win-def:key"/>
                <xsl:with-param name="length" select="string-length($Objects/win-def:registry_object[@id=$object ]/win-def:key) - 1"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="serviceName">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        </xsl:variable>
       
       
            <!--   expected status    -->
        <xsl:variable name="status">
            <xsl:call-template name="getExpectedWinServiceStatus">
                <xsl:with-param name="test" select="$test2"/>
            </xsl:call-template>
        </xsl:variable> 
       
           
        <!-- decides Summary msg Id messgae Id        -->
        <xsl:variable name="summaryMsgId">
            <xsl:if test=" $rs_exDefinition = 'false' ">
                <xsl:text>com.mcafee.pa.msg.failedPreCondition</xsl:text>
            </xsl:if>             
            <xsl:if test=" $rs_exDefinition = 'true' ">
                <xsl:text>com.mcafee.pa.msg.serviceNotDisabled</xsl:text>
            </xsl:if>
        </xsl:variable>
        
     
        
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">       
            
               <xsl:if test=" $rs_exDefinition = 'true' ">
                   
                   
                  <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test2 ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                    
                      <xsl:variable name="itemRef" select="@item_id"/>
                      <xsl:variable name="result" select="@result"/>
                      
                   <xsl:variable name="isViolation">
                       <xsl:call-template name="toggleBoolean">
                           <xsl:with-param name="value">
                               <xsl:value-of select="$result"/>
                           </xsl:with-param>
                       </xsl:call-template>
                   </xsl:variable>
                      
                     <xsl:variable name="actualStartValue" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                     <xsl:variable name="actualStartValueStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value/@status"/>
                      
                      <xsl:variable name="message_id">
                          <xsl:choose>
                              <xsl:when test="$actualStartValueStatus = 'does not exist' ">
                                  <xsl:text>com.mcafee.pa.msg.servicestartparametermissing</xsl:text>                                    
                              </xsl:when>
                              <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                  <xsl:text>com.mcafee.pa.msg.servicestatuserror</xsl:text>                                    
                              </xsl:when>                                
                              <xsl:otherwise>                                
                                  <xsl:text>com.mcafee.pa.msg.servicestatusmessage</xsl:text>
                              </xsl:otherwise>
                          </xsl:choose>
                      </xsl:variable>
                      
                      <xsl:variable name="actualStatus">
                          <xsl:call-template name="getWinServiceStatus">
                              <xsl:with-param name="startValue" select="$actualStartValue"/>
                          </xsl:call-template>
                      </xsl:variable> 
                   
                      <finding messageId="{$message_id}" isViolation="{$isViolation}">
                        <instanceValue key="service">
                            <xsl:value-of select="concat($serviceName,'  ( ' , $serviceExe , ' ) '  )"/>                                                    
                        </instanceValue>                       
                       <instanceValue key="status">
                           <xsl:value-of select="$status"/>                                                    
                       </instanceValue>
                     <!--   <actualValue key="status">
                            <xsl:value-of select="$actualStatus"/>                                                    
                        </actualValue>-->
                   </finding>
                   </xsl:for-each>
               </xsl:if>
            <xsl:if test=" $rs_exDefinition != 'true'  ">
                <finding messageId="{$summaryMsgId}" isViolation="false"/>             
            </xsl:if>
            
        </findings>
        
    </xsl:template>
</xsl:stylesheet>