<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
<!-- compliance finding library for 2 textfilecontent tests OR logic  -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>
        
        <xsl:variable name="software">
        <xsl:if test="contains($title, 'Security Update' )">
                <xsl:value-of select="substring-before($title, 'Security' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
      
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
         <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
       
       <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
    
        <xsl:variable name="filecontentObj_ref1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_ref2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_flag1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects[1]/oval-sc:object[@id=$filecontentObj_ref1]/@flag"/>
        <xsl:variable name="filecontentObj_flag2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects[1]/oval-sc:object[@id=$filecontentObj_ref2]/@flag"/>
        <xsl:variable name="inputVersion" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state/ind-def:subexpression/text()"/>
        
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
               
      
        <xsl:variable name="isViolationValue">
            <xsl:choose>
             <xsl:when test="$result='false'  and $filecontentObj_flag1='does not exist'  and $filecontentObj_flag2='does not exist' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when> 
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:choose>
          <xsl:when test="$result='false'  and $filecontentObj_flag1='does not exist' and $filecontentObj_flag2='does not exist' ">
              <xsl:text>com.mcafee.pa.msg.macsoftwaredoesnotexistmessage</xsl:text>
                </xsl:when>
                <xsl:when test="$result='true' ">
                    <xsl:text>com.mcafee.pa.msg.macSecurityUpdateCheck_CRD_MNAC</xsl:text>
                </xsl:when>
                <xsl:when test="$result='false' ">
                    <xsl:text>com.mcafee.pa.msg.macSecurityUpdateCheck_CRD_MNAC</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
          
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                 <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">software</xsl:attribute>
                    <xsl:value-of select="$software"/>
                </xsl:element>
             <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">inputVersion</xsl:attribute>
        <xsl:value-of select="$inputVersion"/>
                </xsl:element>
          </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

