<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to verify if a list of inetd services are disabled on system.
        
        This library works fine for the below check logic:
        
        <criteria operator='OR'>
            <criterion negate="true" comment='Test for the existence of the file - /etc/inetd.conf' test_ref='oval:com.mcafee.oval:tst:99493' />
            <criteria operator='AND' comment='check for services'>
                <criterion comment='Verify that rlogin is disabled.' test_ref='oval:com.mcafee.oval:tst:7215' />
                <criterion comment='Verify that rexec is disabled.' test_ref='oval:com.mcafee.oval:tst:7216' /> - Optional
                <criterion comment='Verify that rshell is disabled.' test_ref='oval:com.mcafee.oval:tst:7217' /> - Optional
                  there could more service criteria here ....
        </criteria>
        </criteria>
        
        Test cases:
         1. Pass - Confuguration is set as required,
         2. Pass - Inetd service is not installed. 
         3. Fail -  The at least one of inetd service/s is/are not disabled.
        
        Example def id: oval:com.mcafee.oval:def:7211
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
  
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[@id=$definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- 
        <xsl:variable name="inetdTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test[1]/@id"/>
        <xsl:variable name="inetdTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test[2]/@id"/>
        <xsl:variable name="inetdTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test[3]/@id"/>
         
        <xsl:variable name="inetdRes1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$inetdTest_id1]/@result"/>
        <xsl:variable name="inetdRes2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$inetdTest_id2]/@result"/>
        <xsl:variable name="inetdRes3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$inetdTest_id3]/@result"/>
       -->
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="fileRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
        
        <xsl:variable name="srvcList">
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/unix-def:inetd_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>inetdTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='inetdTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false'  or @result = 'not evaluated']">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="inetdTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:inetd_item[@id=$itemRef]" />
                    <xsl:if test="not($inetdTestItem/@status)">
                        <xsl:value-of select="concat($inetdTestItem/unix-sc:service_name/text(),' ', '(', $inetdTestItem/unix-sc:protocol/text(),')', '      ')"/>    
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
              
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$fileRes='true'">
                            <xsl:text>com.mcafee.pa.msg.InetdStatusSCAP</xsl:text>        
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                        </xsl:otherwise>
                        <!-- <xsl:when test="($inetdRes1='true' and $inetdRes2='true' and $inetdRes3='true') or ($inetdRes1='not applicable' and $inetdRes2='not applicable' and $inetdRes3='not applicable')">
                            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                        </xsl:when> -->
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$result='false'">
                    <xsl:text>com.mcafee.pa.msg.linuxInetdSrvListExpDisabled</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">service_list</xsl:attribute>
                    <xsl:value-of select="$srvcList"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>