<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
 
 
    <!--
        
        
        This XSLT is used for the definition which are used to verify the certain file permission.
        Definition schema should be like this
        
        schema
        criteria (and)    
            extend  definition  
            criteria (and )
                    extend  definition
                    criteria  (and )
                        criterion   File Effectiverights tests
                        one or more
                    /criteria
            /criteria
        /criteria                
    -->
    
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <xsl:template name="getWinFileRights">
        <xsl:param name="testId"/>
        
        <xsl:variable name="state_53">
            <xsl:value-of select="$Tests/win-def:fileeffectiverights53_test[@id=$testId]/win-def:state/@state_ref"/>            
        </xsl:variable>
        
        <xsl:variable name="state_">
            <xsl:value-of select="$Tests/win-def:fileeffectiverights_test[@id=$testId]/win-def:state/@state_ref"/>            
        </xsl:variable>
        
        <xsl:variable name="state">
            <xsl:if test="$state_53 != '' ">
                <xsl:value-of select="$state_53"/>
            </xsl:if>
            <xsl:if test="$state_ != '' ">
                <xsl:value-of select="$state_"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:if test="$States/win-def:fileeffectiverights_state[ @id = $state ]" >
            <xsl:variable name="full">
                <xsl:for-each select="$States/win-def:fileeffectiverights_state[ @id = $state ]/*">                
                    <xsl:value-of select="."/>                                              
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="permissions">
                <xsl:variable name="read" select="$States/win-def:fileeffectiverights_state[ @id = $state ]/win-def:file_read_data/text()"/>
                <xsl:variable name="write" select="$States/win-def:fileeffectiverights_state[ @id = $state ]/win-def:file_write_data/text()"/>
                <xsl:variable name="execute" select="$States/win-def:fileeffectiverights_state[ @id = $state ]/win-def:file_execute/text()"/>
                
                <xsl:if test="$read = '1' ">
                    <xsl:text>read,</xsl:text>
                </xsl:if>
                <xsl:if test="$write = '1' ">
                    <xsl:text>write,</xsl:text>
                </xsl:if>
                <xsl:if test="$execute = '1' ">
                    <xsl:text>execute,</xsl:text>
                </xsl:if>
            </xsl:variable>
            <xsl:choose>                 
                <xsl:when test="not(contains($full,0))">
                    <xsl:text>full</xsl:text>
                </xsl:when>
                <xsl:when test="not(contains($full,1))">
                    <xsl:text>none</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="substring($permissions,1,string-length($permissions)-1)"/>
                </xsl:otherwise>
            </xsl:choose>             
        </xsl:if>
        
        <xsl:if test="$States/win-def:fileeffectiverights53_state[ @id = $state ]" >
            <xsl:variable name="full">
                <xsl:for-each select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/*">                
                    <xsl:value-of select="."/>                                              
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="permissions">
                <xsl:variable name="read" select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/win-def:file_read_data/text()"/>
                <xsl:variable name="write" select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/win-def:file_write_data/text()"/>
                <xsl:variable name="execute" select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/win-def:file_execute/text()"/>
                
                <xsl:if test="$read = '1' ">
                    <xsl:text>read,</xsl:text>
                </xsl:if>
                <xsl:if test="$write = '1' ">
                    <xsl:text>write,</xsl:text>
                </xsl:if>
                <xsl:if test="$execute = '1' ">
                    <xsl:text>execute,</xsl:text>
                </xsl:if>
            </xsl:variable>
            <xsl:choose>                 
                <xsl:when test="not(contains($full,0))">
                    <xsl:text>full</xsl:text>
                </xsl:when>
                <xsl:when test="not(contains($full,1))">
                    <xsl:text>none</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="substring($permissions,1,string-length($permissions)-1)"/>
                </xsl:otherwise>
            </xsl:choose>
            
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="getMessageId">
        <xsl:param name="permission"/>
        <xsl:param name="result"/>
        <xsl:param name="file_status"/>
        <xsl:param name="user_status"/>
        
        
        <xsl:choose>
            <xsl:when test="$file_status = 'does not exist' ">
                <xsl:text>com.mcafee.pa.msg.filedoesnotexist</xsl:text>                                    
            </xsl:when>
            <xsl:when test="$user_status = 'does not exist' ">
                <xsl:text>com.mcafee.pa.msg.userdoesnotexist</xsl:text>                                    
            </xsl:when>
            <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                <xsl:text>com.mcafee.pa.msg.filerightsviolationerror</xsl:text>                                    
            </xsl:when>                                
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$permission = 'full' ">
                        <xsl:text>com.mcafee.pa.msg.winfilefullrightsviolation</xsl:text>
                    </xsl:when>
                    <xsl:when test="$permission = 'none' ">
                        <xsl:text>com.mcafee.pa.msg.winfilenonerightsviolation</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.winfilerightsviolation</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>                  
            </xsl:otherwise>
        </xsl:choose>
        
        
        
    </xsl:template>
    
    <xsl:template name="getActualWinFileRights">
        <xsl:param name="id"/>
        
        <xsl:variable name="full">
            <xsl:for-each select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/*">
                <xsl:if test="contains(name(), 'standard_' ) or contains(name(), 'access_' ) or contains(name(), 'generic_' ) or  contains(name(), 'file_' ) ">
                    <xsl:value-of select="."/>
                </xsl:if>                
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="permissions">
            <xsl:variable name="read" select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/win-sc:file_read_data/text()"/>
            <xsl:variable name="write" select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/win-sc:file_write_data/text()"/>
            <xsl:variable name="execute" select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/win-sc:file_execute/text()"/>
            
            <xsl:if test="$read = '1' ">
                <xsl:text>read,</xsl:text>
            </xsl:if>
            <xsl:if test="$write = '1' ">
                <xsl:text>write,</xsl:text>
            </xsl:if>
            <xsl:if test="$execute = '1' ">
                <xsl:text>execute,</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>                 
            <xsl:when test="not(contains($full,0))">
                <xsl:text>full</xsl:text>
            </xsl:when>
            <xsl:when test="not(contains($full,1))">
                <xsl:text>none</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring($permissions,1,string-length($permissions)-1)"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
  
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' ">
            <xsl:call-template name="winFileRightViolations02">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winFileRightViolations02">
        <xsl:param name="definitionId"/>       
       
      
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criteria/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                    </xsl:element>
            </xsl:for-each>            
        </xsl:variable>
        
            <!-- if machine is windows -->
          <xsl:variable name="pre_test_result">
                  <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:extend_definition/@result"/>              
          </xsl:variable>
        

        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">       
                             
         <xsl:if test=" $pre_test_result = 'true'  ">
             
             
              <xsl:for-each select="xalan:nodeset($tests)/*">
                  <xsl:variable name="test" select="@id"/>
                  
                  <xsl:variable name="permission">
                      <xsl:call-template name="getWinFileRights">
                          <xsl:with-param name="testId" select="$test"/>
                      </xsl:call-template>
                  </xsl:variable>
                  
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ]">
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:variable name="account"
                            select="$SystemData/win-sc:fileeffectiverights_item[@id=$itemRef]/win-sc:trustee_name"/>
                        <xsl:variable name="filename"
                            select="$SystemData/win-sc:fileeffectiverights_item[@id=$itemRef]/win-sc:filename"/>
                          <xsl:variable name="path"
                          select="$SystemData/win-sc:fileeffectiverights_item[@id=$itemRef]/win-sc:path"/>
                  
                   <xsl:variable name="message_id">
                       <xsl:call-template name="getMessageId">
                           <xsl:with-param name="permission" select="$permission"/>
                           <xsl:with-param name="result" select="$result"/>
                           <xsl:with-param name="file_status" select="$SystemData/win-sc:fileeffectiverights_item[@id=$itemRef]/win-sc:filename/@status"/>
                           <xsl:with-param name="user_status" select="$SystemData/win-sc:fileeffectiverights_item[@id=$itemRef]/win-sc:trustee_name/@status"/>
                       </xsl:call-template>
                   </xsl:variable>
                        
                        
                        
                        <xsl:variable name="actualPermission">
                            <xsl:call-template name="getActualWinFileRights">
                                <xsl:with-param name="id" select="$itemRef"/> 
                            </xsl:call-template>
                        </xsl:variable>
                        
                        <finding messageId="{$message_id}" isViolation="true">
                            <instanceValue key="account">
                                <xsl:value-of select="$account"/>
                                <xsl:text/>
                            </instanceValue>
                            <instanceValue key="filename">
                                <xsl:value-of select="$path"/><xsl:value-of select="$filename"/>
                            </instanceValue>
                            <instanceValue key="permissions">
                                <xsl:value-of select="$permission"/>
                            </instanceValue>
                            <actualValue key="permissions">
                                <xsl:value-of select="$actualPermission"/>
                            </actualValue>
                        </finding>
                        
                    
            </xsl:for-each>
           </xsl:for-each>
          </xsl:if>
            <xsl:if test=" $pre_test_result != 'true'  ">
                <finding messageId="com.mcafee.pa.msg.notApplicableOs" isViolation="false"/>             
            </xsl:if>
            
        </findings>       
        
        
     </xsl:template>
            
</xsl:stylesheet>