#!/bin/sh
usage()
{
    echo "Usage: $command [-u version  ]"
    echo "-u : upgrade install"
    echo "version :5.7.8.112"
    echo "-h : show this help"
}
if [ $# -eq 0 ]; then 
    usage
    exit 1
fi

while getopts u:a opt
  do    case "$opt" in
      u)  msgbus_current_version="$OPTARG";;
      h)  usage
      exit 0;;
      [?])    usage
      exit 1;;
  esac
done
if [ -f "/etc/ma.d/mainfo.ini" ]; then
	echo "Changing the ownership of cert file"
	chown mfe /var/McAfee/agent/certstore/*
	echo "new msgbus version updating = $msgbus_current_version"
	old_Version=`cat /etc/ma.d/mainfo.ini |grep MsgbusVersion |cut -d'=' -f2`
	echo "old Version= $old_Version"
	if [ $old_Version = $msgbus_current_version ]; then
		exit 0
	fi
	sed -e "s:MsgbusVersion=$old_Version:MsgbusVersion=$msgbus_current_version:g" /etc/ma.d/mainfo.ini >/etc/ma.d/mainfo.ini_tmp
	mv /etc/ma.d/mainfo.ini_tmp /etc/ma.d/mainfo.ini
	sleep 5
	touch /etc/ma.d/__ma_notify__
	rm -rf /etc/ma.d/__ma_notify__
else
	echo "MsgbusVersion=$msgbus_current_version" >/etc/ma.d/mainfo.ini
fi