<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        
        Criterio ( and )
            citerion family test           :  To check whether OS is windows platform
            criterion  password policy test :   To check one of the password parameter  
            ...
            <max_passwd_age datatype="int">3628800</max_passwd_age>
            <min_passwd_age datatype="int">0</min_passwd_age>
            <min_passwd_len datatype="int">0</min_passwd_len>
            <password_hist_len datatype="int">0</password_hist_len>
            <password_complexity datatype="boolean">0</password_complexity>
            <reversible_encryption datatype="boolean">0</reversible_encryption>
 
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
   
    
    <xsl:template name="getMessageId">
        <xsl:param name="operation"/>
        <xsl:param name="password_parameter"/>
        <xsl:param name="status"/>

        
        <xsl:choose>
            <xsl:when test="$password_parameter = 'max_passwd_age'  ">
                <xsl:choose>
                  <xsl:when test=" $operation = 'less than or equal' ">
                     <xsl:text>com.mcafee.pa.msg.winmaxpasswdagelessthansetting</xsl:text>
                 </xsl:when>
                 <xsl:when test=" $operation = 'not equal' ">
                    <xsl:text>com.mcafee.pa.msg.winmaxpasswdagenotequalsetting</xsl:text>
                 </xsl:when>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>com.mcafee.pa.msg.winmaxpasswdageequalsetting</xsl:text>
                    </xsl:when>
                 </xsl:choose>
            </xsl:when>
            
            <xsl:when test="$password_parameter = 'min_passwd_age'  ">
                <xsl:choose>
                    <xsl:when test=" $operation = 'less than or equal' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdagegreaterthansetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than or equal' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdagegreaterthansetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdagenotequalsetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdageequalsetting</xsl:text>
                    </xsl:when>
                 </xsl:choose>               
            </xsl:when>
			
           <xsl:when test="$password_parameter = 'min_passwd_len'  ">
                <xsl:choose>                                    
                    <xsl:when test=" $operation = 'less than or equal' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdlengreaterthansetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdlenequalssetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than or equal' ">
                        <xsl:text>com.mcafee.pa.msg.winminpasswdlengreaterthansetting</xsl:text>
                    </xsl:when>
                 </xsl:choose>
            </xsl:when>
            
            <xsl:when test="$password_parameter = 'password_hist_len'  ">
                <xsl:choose>
                    <xsl:when test=" $operation = 'less than or equal' ">
                        <xsl:text>com.mcafee.pa.msg.winpasswdhistlengreaterthansetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than or equal' ">
                        <xsl:text>com.mcafee.pa.msg.winpasswdhistlengreaterthansetting</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>com.mcafee.pa.msg.winpasswdhistlenequalssetting</xsl:text>
                    </xsl:when>
                  </xsl:choose>
            </xsl:when>
            
           <xsl:when test="$password_parameter = 'password_complexity'  ">
                <xsl:text>com.mcafee.pa.msg.winpasswordcomplexitysetting</xsl:text>
            </xsl:when>
            <xsl:when test="$password_parameter = 'reversible_encryption'  ">
                <xsl:text>com.mcafee.pa.msg.winreversibleencryptionsetting</xsl:text>
            </xsl:when>
            
        </xsl:choose>
 
    </xsl:template>
    
    
    <xsl:template name="getPasswordParameterPrintableValue">
        <xsl:param name="password_parameter"/>
        <xsl:param name="numaricValue"/>
        
        
        <xsl:choose>
            <xsl:when test="$numaricValue = '' ">
                <xsl:text>Unknown</xsl:text>
            </xsl:when>
            <xsl:when test="$password_parameter = 'max_passwd_age'  or $password_parameter = 'min_passwd_age' ">
                <xsl:choose>
                    <xsl:when test="number(number($numaricValue) div  number( 60 * 60 * 24 )) &gt;= 1">
                        <xsl:variable name="calculateValue">                            
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 60 * 24 )"/>
                        </xsl:variable>
                        <!-- <xsl:value-of select="round($numaricValue)"/><xsl:text> (</xsl:text><xsl:value-of select="round($calculateValue)"/><xsl:text> days)</xsl:text><xsl:text> seconds</xsl:text> -->
                        <xsl:value-of select="round($numaricValue)"/><xsl:text> seconds</xsl:text><xsl:text> (</xsl:text><xsl:value-of select="round($calculateValue)"/><xsl:text> days)</xsl:text>
                    </xsl:when>
                    <xsl:when test="number(number($numaricValue) div  number( 60 * 60 )) &gt;= 1">
                        <xsl:variable name="calculateValue">                            
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 60 )"/>
                        </xsl:variable>
                        <xsl:value-of select="round($numaricValue)"/><xsl:text> (</xsl:text><xsl:value-of select="round($calculateValue)"/><xsl:text> hours)</xsl:text><xsl:text> seconds</xsl:text>                                
                    </xsl:when>
                    <xsl:when test="number(number($numaricValue) div  60) &gt;= 1">
                        <xsl:variable name="calculateValue">                            
                            <xsl:value-of select="number($numaricValue) div  60 "/>
                        </xsl:variable>
                        <xsl:value-of select="round($numaricValue)"/><xsl:text> (</xsl:text><xsl:value-of select="round($calculateValue)"/><xsl:text> minutes)</xsl:text><xsl:text> seconds</xsl:text>                                
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="round($numaricValue)"/><xsl:text> seconds</xsl:text>                                
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$password_parameter = 'password_complexity'  or $password_parameter = 'reversible_encryption'  ">
                <xsl:choose>
                    <xsl:when test="$numaricValue = '0'  or $numaricValue = 'false' ">
                        <xsl:text>Disabled (0)</xsl:text>
                    </xsl:when>
                    <xsl:when test="$numaricValue = '1' or $numaricValue = 'true' ">
                        <xsl:text>Enabled (1)</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$numaricValue"/>
                    </xsl:otherwise>
                </xsl:choose>                
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$numaricValue"/>
            </xsl:otherwise>
        </xsl:choose>
       
    </xsl:template>
          
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        
            <xsl:call-template name="winPasswordCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="def_result" select="$result"/>
            </xsl:call-template>
        
        
    </xsl:template>
    
    <xsl:template name="winPasswordCheck">
        <xsl:param name="definitionId"/>       
        <xsl:param name="def_result"/>
        
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
            
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:passwordpolicy_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/win-def:passwordpolicy_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:passwordpolicy_test[@id=$test]/win-def:state/@state_ref"/>
                
                                        
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>password</xsl:text>
                        </xsl:attribute>          
                        </xsl:element>
                  </xsl:if>
            </xsl:for-each>            
            
        </xsl:variable>
           
            <xsl:if test="$def_result = 'false' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='password' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                 
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:for-each select="$States/win-def:passwordpolicy_state[@id=$state]/*">
                            <xsl:variable name="password_parameter" select="name(.)"/>
                            <xsl:variable name="externalVarId" select="@var_ref"/>
                            <xsl:variable name="operation" select="@operation"></xsl:variable>
                            <xsl:variable name="expectedValue">
                                <xsl:choose>
                                    <xsl:when test="string($externalVarId) != ''">
                                       <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="."/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>    
                           
                            <xsl:for-each select="$SystemData/win-sc:passwordpolicy_item[@id=$itemRef]/*">
                                <xsl:if test="name(.) = $password_parameter">
                                    <xsl:variable name="actualParameterValue" select="text()"/>
                                    <xsl:variable name="actualParameterStatus">
                                        <xsl:if test="$actualParameterValue = '' ">
                                            <xsl:text>does not exist</xsl:text>
                                        </xsl:if>    
                                    </xsl:variable>
                                    <xsl:variable name="message_id">                           
                                        <xsl:call-template name="getMessageId">
                                            <xsl:with-param name="operation" select="$operation"/>
                                            <xsl:with-param name="password_parameter" select="$password_parameter"/>
                                            <xsl:with-param name="status" select="$actualParameterStatus"/>
                                        </xsl:call-template>                            
                                    </xsl:variable>
                                                                         
                                    <xsl:if test="$message_id != '' and $expectedValue != $actualParameterValue">
                                        <xsl:variable name="inputPasswordParameterValue">
                                            <xsl:call-template name="getPasswordParameterPrintableValue">
                                                <xsl:with-param name="password_parameter" select="$password_parameter"  />
                                                <xsl:with-param name="numaricValue" select="$expectedValue"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <xsl:variable name="actualParameterPrintableValue">
                                            <xsl:call-template name="getPasswordParameterPrintableValue">
                                                <xsl:with-param name="password_parameter" select="$password_parameter"  />
                                                <xsl:with-param name="numaricValue" select="$actualParameterValue"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <finding messageId="{$message_id}" isViolation="true">
                                            <instanceValue key="inputValue">
                                                <xsl:value-of select="$inputPasswordParameterValue"/>                                                    
                                            </instanceValue>
                                            <actualValue key="actualValue">
                                                <xsl:value-of select="$actualParameterPrintableValue"/>                                                    
                                            </actualValue>
                                        </finding>
                                    </xsl:if>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:for-each>                                                                       
                    </xsl:for-each>
                </xsl:for-each>
                </findings>
            </xsl:if>            
    
            <xsl:if test=" $def_result = 'true' ">                
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='password' ]">
                        <xsl:variable name="test" select="@id"/>
                        <xsl:variable name="state" select="@state"/>                        
                        
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:for-each select="$States/win-def:passwordpolicy_state[@id=$state]/*">
                                <xsl:variable name="password_parameter" select="name(.)"/>
                                <xsl:variable name="externalVarId" select="@var_ref"/>
                                <xsl:variable name="operation" select="@operation"></xsl:variable>
				<xsl:variable name="expectedValue">
				    <xsl:choose>
				        <xsl:when test="string($externalVarId) != ''">
				            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
				        </xsl:when>
					<xsl:otherwise>
					    <xsl:value-of select="."/>
					</xsl:otherwise>
				    </xsl:choose>
				</xsl:variable>                                    
                                
                                <xsl:for-each select="$SystemData/win-sc:passwordpolicy_item[@id=$itemRef]/*">
                                    <xsl:if test="name(.) = $password_parameter">
                                        <xsl:variable name="actualParameterValue" select="text()"/>
                                        <xsl:variable name="actualParameterStatus">
                                            <xsl:if test="$actualParameterValue = '' ">
                                                <xsl:text>does not exist</xsl:text>
                                            </xsl:if>    
                                        </xsl:variable>
                                        <xsl:variable name="message_id">                           
                                            <xsl:call-template name="getMessageId">
                                                <xsl:with-param name="operation" select="$operation"/>
                                                <xsl:with-param name="password_parameter" select="$password_parameter"/>
                                                <xsl:with-param name="status" select="$actualParameterStatus"/>
                                            </xsl:call-template>                            
                                        </xsl:variable>
                                        
                                        <xsl:if test="$message_id != ''">
                                            <xsl:variable name="inputPasswordParameterValue">
                                                <xsl:call-template name="getPasswordParameterPrintableValue">
                                                    <xsl:with-param name="password_parameter" select="$password_parameter"  />
                                                    <xsl:with-param name="numaricValue" select="$expectedValue"/>
                                                </xsl:call-template>
                                            </xsl:variable>
                                            <xsl:variable name="actualParameterPrintableValue">
                                                <xsl:call-template name="getPasswordParameterPrintableValue">
                                                    <xsl:with-param name="password_parameter" select="$password_parameter"  />
                                                    <xsl:with-param name="numaricValue" select="$actualParameterValue"/>
                                                </xsl:call-template>
                                            </xsl:variable>
                                            <finding messageId="{$message_id}" isViolation="false">
                                                <instanceValue key="inputValue">
                                                    <xsl:value-of select="$inputPasswordParameterValue"/>                                                    
                                                </instanceValue>
                                                <actualValue key="actualValue">
                                                    <xsl:value-of select="$actualParameterPrintableValue"/>                                                    
                                                </actualValue>
                                            </finding>
                                        </xsl:if>
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:for-each>                                                                       
                        </xsl:for-each>
                    </xsl:for-each>
               </findings>
           </xsl:if>            
                             
    </xsl:template>

</xsl:stylesheet>