
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
 
 
    <!--
        schema
        criteria
                criteria
                               any thg
                /criteria
                criteria
            
                criterion
                    .... n no
                /criteria
        /criteria
        
    -->
    
    <xsl:include  href="common.xsl" />
    
    <xsl:template name="getWinFileRights">
        <xsl:param name="testId"/>
        
        <xsl:variable name="state_53">
            <xsl:value-of select="$Tests/win-def:fileeffectiverights53_test[@id=$testId]/win-def:state/@state_ref"/>            
        </xsl:variable>
        
        <xsl:variable name="state_">
            <xsl:value-of select="$Tests/win-def:fileeffectiverights_test[@id=$testId]/win-def:state/@state_ref"/>            
        </xsl:variable>
        
        <xsl:variable name="state">
            <xsl:if test="$state_53 != '' ">
                <xsl:value-of select="$state_53"/>
            </xsl:if>
            <xsl:if test="$state_ != '' ">
                <xsl:value-of select="$state_"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:if test="$States/win-def:fileeffectiverights_state[ @id = $state ]" >
             <xsl:variable name="full">
                    <xsl:for-each select="$States/win-def:fileeffectiverights_state[ @id = $state ]/*">                
                             <xsl:value-of select="."/>                                              
                     </xsl:for-each>
             </xsl:variable>
       
             <xsl:variable name="permissions">
                         <xsl:variable name="read" select="$States/win-def:fileeffectiverights_state[ @id = $state ]/win-def:file_read_data/text()"/>
                         <xsl:variable name="write" select="$States/win-def:fileeffectiverights_state[ @id = $state ]/win-def:file_write_data/text()"/>
                         <xsl:variable name="execute" select="$States/win-def:fileeffectiverights_state[ @id = $state ]/win-def:file_execute/text()"/>
                         
                         <xsl:if test="$read = '1' ">
                             <xsl:text>read,</xsl:text>
                         </xsl:if>
                         <xsl:if test="$write = '1' ">
                             <xsl:text>write,</xsl:text>
                         </xsl:if>
                         <xsl:if test="$execute = '1' ">
                             <xsl:text>execute,</xsl:text>
                         </xsl:if>
             </xsl:variable>
             <xsl:choose>                 
                 <xsl:when test="not(contains($full,0))">
                     <xsl:text>full</xsl:text>
                 </xsl:when>
                 <xsl:when test="not(contains($full,1))">
                     <xsl:text>none</xsl:text>
                 </xsl:when>
                 <xsl:otherwise>
                     <xsl:value-of select="substring($permissions,1,string-length($permissions)-1)"/>
                 </xsl:otherwise>
             </xsl:choose>             
         </xsl:if>
        
        <xsl:if test="$States/win-def:fileeffectiverights53_state[ @id = $state ]" >
            <xsl:variable name="full">
                <xsl:for-each select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/*">                
                    <xsl:value-of select="."/>                                              
                </xsl:for-each>
            </xsl:variable>
    
            <xsl:variable name="permissions">
                <xsl:variable name="read" select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/win-def:file_read_data/text()"/>
                <xsl:variable name="write" select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/win-def:file_write_data/text()"/>
                <xsl:variable name="execute" select="$States/win-def:fileeffectiverights53_state[ @id = $state ]/win-def:file_execute/text()"/>
                
                <xsl:if test="$read = '1' ">
                    <xsl:text>read,</xsl:text>
                </xsl:if>
                <xsl:if test="$write = '1' ">
                    <xsl:text>write,</xsl:text>
                </xsl:if>
                <xsl:if test="$execute = '1' ">
                    <xsl:text>execute,</xsl:text>
                </xsl:if>
            </xsl:variable>
            <xsl:choose>                 
                <xsl:when test="not(contains($full,0))">
                    <xsl:text>full</xsl:text>
                </xsl:when>
                <xsl:when test="not(contains($full,1))">
                    <xsl:text>none</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="substring($permissions,1,string-length($permissions)-1)"/>
                </xsl:otherwise>
            </xsl:choose>
            
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="getMessageId">
        <xsl:param name="permission"/>
        <xsl:param name="result"/>
        <xsl:param name="file_status"/>
        <xsl:param name="user_status"/>
        
   
            <xsl:choose>
                <xsl:when test="$file_status = 'does not exist' ">
                    <xsl:text>com.mcafee.pa.msg.filedoesnotexist</xsl:text>                                    
                </xsl:when>
                <xsl:when test="$user_status = 'does not exist' ">
                    <xsl:text>com.mcafee.pa.msg.userdoesnotexist</xsl:text>                                    
                </xsl:when>
                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                    <xsl:text>com.mcafee.pa.msg.filerightsviolationerror</xsl:text>                                    
                </xsl:when>                                
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="$permission = 'full' ">
                            <xsl:text>com.mcafee.pa.msg.winfilefullrightsviolation</xsl:text>
                        </xsl:when>
                        <xsl:when test="$permission = 'none' ">
                            <xsl:text>com.mcafee.pa.msg.winfilenonerightsviolation</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>com.mcafee.pa.msg.winfilerightsviolation</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>                  
                </xsl:otherwise>
            </xsl:choose>
   
        
        
    </xsl:template>
    
    <xsl:template name="getActualWinFileRights">
        <xsl:param name="id"/>
        
        <xsl:variable name="full">
            <xsl:for-each select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/*">
                <xsl:if test="contains(name(), 'standard_' ) or contains(name(), 'access_' ) or contains(name(), 'generic_' ) or  contains(name(), 'file_' ) ">
                    <xsl:value-of select="."/>
                </xsl:if>                
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="permissions">
            <xsl:variable name="read" select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/win-sc:file_read_data/text()"/>
            <xsl:variable name="write" select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/win-sc:file_write_data/text()"/>
            <xsl:variable name="execute" select="$SystemData/win-sc:fileeffectiverights_item[@id=$id]/win-sc:file_execute/text()"/>
            
            <xsl:if test="$read = '1' ">
                <xsl:text>read,</xsl:text>
            </xsl:if>
            <xsl:if test="$write = '1' ">
                <xsl:text>write,</xsl:text>
            </xsl:if>
            <xsl:if test="$execute = '1' ">
                <xsl:text>execute,</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>                 
            <xsl:when test="not(contains($full,0))">
                <xsl:text>full</xsl:text>
            </xsl:when>
            <xsl:when test="not(contains($full,1))">
                <xsl:text>none</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring($permissions,1,string-length($permissions)-1)"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
   
</xsl:stylesheet>