<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
       This XSL library is to be applied to definitions which are made to check whether a installed  windows Security Software meets the 
       maximum DAT Age requirement. Software name will be get from the title. Title should start with software name as below.
       
        <windows security software name> Maximum DAT Age
        
        Criteria logic
        
        <criteria AND>
            <Criterion> <Security Software Existence>
            <Criterion> <Security Software DAT Age test >
    -->
 
 <!-- Important nodes and their xpath trace  -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="SystemData"
 select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics"/>
    <xsl:variable name="System"
        select="/oval-res:oval_results/oval-res:results/oval-res:system"/>
    <xsl:variable name="States"
    select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"  
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>     
    </xsl:template>

    <!-- Get Software name from Title -->
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>        
        <xsl:variable name="software">
            <xsl:if test="contains($title, 'Maximum' )">
                <xsl:value-of select="substring-before($title, 'Maximum' )"/>
            </xsl:if>
            <xsl:if test="contains($title, 'Minimum' )">
                <xsl:value-of select="substring-before($title, 'Minimum' )"/>
            </xsl:if>
            <xsl:if test="contains($title, 'Security Update' )">
                <xsl:value-of select="substring-before($title, 'Security' )"/>
            </xsl:if>
        </xsl:variable>    
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose> 
     </xsl:template>
 
    <!-- definition for getFindings() function, Definition Id and result -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!--    We will now remove common from the definition Id being passed, because for MNAC L10 checks
            main definition id is with common in it. but we need to remove that for logic to traverse for tests to work. -->
        <xsl:variable name="definitionIdWithoutCommon">
            <xsl:choose>   
                <xsl:when test="contains($definitionId, '.common' )">
                    <xsl:value-of select="concat(substring-before($definitionId, '.common'), substring-after($definitionId, '.common'))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$definitionId"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/@result"/>
        <xsl:call-template name="winSecSoftwareDATageCheck">
            <xsl:with-param name="definitionId" select="$definitionIdWithoutCommon"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
    </xsl:template>
   
    <!-- definition for winSecSoftwareDATageCheck() function -->
    <xsl:template name="winSecSoftwareDATageCheck">
        <xsl:param name="definitionId"/>       
        <xsl:param name="def_result"/>
        
        <!-- Definition title -->  
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <!-- Software name -->  
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
		
        <!--Capture Variable test id-->
        <xsl:variable name="variable_test_id">
            <xsl:value-of select="$Tests/oval-ind:variable_test/@id"/>
        </xsl:variable>
        <!--Capture variable tested item id-->
        <xsl:variable name="tested_item_id">
            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$variable_test_id]/oval-res:tested_item/@item_id"/>
        </xsl:variable>
        <!-- Capture external variable id, variable reference,  expected DAT Age Value, actual DAT Age value -->
        <xsl:variable name="external_variable_id" select="$Variables/oval-def:external_variable/@id"/>
        <xsl:variable name="state_id" select="$States/oval-ind:variable_state/@id"/>
        <xsl:variable name="var_reference" select="$States/oval-ind:variable_state[@id=$state_id]/oval-ind:value/@var_ref"/>
        <xsl:variable name="expectedDATageValue" select="$TestedItems/oval-res:test[@test_id=$variable_test_id]/oval-res:tested_variable[@variable_id=$var_reference]/text()"/>
        <xsl:variable name="actualDATageValue" select="$SystemData/oval-sc:system_data/*[namespace-uri(/*) and local-name()='variable_item']/*[namespace-uri(/*) and local-name()='value']"/>

        <!-- calculate the number of tests in the definition, this will be helpful in generating only one finding message in case of  multiple tests -->
        <xsl:variable name="critCount" select="count($OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion)"/>

        <!-- check if it is Registry Test-->   
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:variable name="crit_res" select="@result"/>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
                    <xsl:variable name="key" select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                    <xsl:variable name="name" select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>                 
                    <xsl:variable name="externalVar" select="$States/win-def:registry_state[@id=$state]/win-def:value/@var_ref"/>
                    <xsl:variable name="datatype" select="$States/win-def:registry_state[@id=$state]/win-def:value/@datatype"/>
                    <xsl:variable name="operation" select="$States/win-def:registry_state[@id=$state]/win-def:value/@operation"/>
                    
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="test_result">
                            <xsl:value-of select="$crit_res"/>
                        </xsl:attribute>
                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        <xsl:attribute name="datatype">
                            <xsl:value-of select="$datatype"/>
                        </xsl:attribute>
                        <xsl:attribute name="testtype">
                            <xsl:text>registry</xsl:text>
                        </xsl:attribute>                       
                     </xsl:element>
                </xsl:if>                
   
                <!-- check if it is Variable Test-->
                <xsl:if test="$Tests/oval-ind:variable_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:state/@state_ref"/>                    
                    <xsl:variable name="variableObjectRef" select="$Objects/oval-ind:variable_object[@id=$object]/oval-ind:var_ref"/>                    
                    <xsl:variable name="externalVar" select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value/@var_ref"/>                    
                    <xsl:variable name="datatype" select="$States/oval-ind:variable_state[@id=$state]/oval-indvalue/@datatype"/>
                    <xsl:variable name="operation" select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value/@operation"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <!-- <xsl:attribute name="test_result">
                            <xsl:value-of select="$crit_res"/>
                        </xsl:attribute> -->
                        <xsl:attribute name="variableObjectRef">
                            <xsl:value-of select="$variableObjectRef"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        <xsl:attribute name="datatype">
                            <xsl:value-of select="$datatype"/>
                        </xsl:attribute>
                        <xsl:attribute name="testtype">
                            <xsl:text>variable</xsl:text>
                        </xsl:attribute>                    
                     </xsl:element>
                </xsl:if>
 
                <!-- check if it is File Test -->             
                <xsl:if test="$Tests/win-def:file_test[@id=$test]">                    
                    <xsl:variable name="state"  select="$Tests/win-def:file_test[@id=$test]/win-def:state/@state_ref"/>                    
                    <xsl:choose>                        
                        <xsl:when test="$States/win-def:file_state[@id=$state]/win-def:version">
                            <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                            <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version/@var_ref"/>
                            <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:version/@operation"/>
                            <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="test_result">
                                    <xsl:value-of select="$crit_res"/>
                                </xsl:attribute>
                                <xsl:attribute name="versionnodename">
                                    <xsl:value-of select="$versionnode"/>
                                </xsl:attribute>
                                <xsl:attribute name="externalVar">
                                    <xsl:value-of select="$externalVar"/>
                                </xsl:attribute>
                                <xsl:attribute name="operation">
                                    <xsl:value-of select="$operation"/>
                                </xsl:attribute>                                
                                <xsl:attribute name="testtype">
                                    <xsl:text>file</xsl:text>
                                </xsl:attribute>                                
                            </xsl:element>
                        </xsl:when>                        
                        
                        <xsl:when  test="$States/win-def:file_state[@id=$state]/win-def:product_version">
                            <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:product_version)"/>
                            <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@var_ref"/>
                            <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@operation"/>
                            <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="test_result">
                                    <xsl:value-of select="$crit_res"/>
                                </xsl:attribute>
                                <xsl:attribute name="versionnodename">
                                    <xsl:value-of select="$versionnode"/>
                                </xsl:attribute>
                                <xsl:attribute name="externalVar">
                                    <xsl:value-of select="$externalVar"/>
                                </xsl:attribute>
                                <xsl:attribute name="operation">
                                    <xsl:value-of select="$operation"/>
                                </xsl:attribute>                                
                                <xsl:attribute name="testtype">
                                    <xsl:text>file</xsl:text>
                                </xsl:attribute>                                
                            </xsl:element>
                        </xsl:when>

                        <xsl:otherwise>
                            <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                            <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version/@var_ref"/>
                            <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:version/@operation"/>
                            <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="test_result">
                                    <xsl:value-of select="$crit_res"/>
                                </xsl:attribute>
                                <xsl:attribute name="versionnodename">
                                    <xsl:value-of select="$versionnode"/>
                                </xsl:attribute>
                                <xsl:attribute name="externalVar">
                                    <xsl:value-of select="$externalVar"/>
                                </xsl:attribute>
                                <xsl:attribute name="operation">
                                    <xsl:value-of select="$operation"/>
                                </xsl:attribute>                                
                                <xsl:attribute name="testtype">
                                    <xsl:text>file</xsl:text>
                                </xsl:attribute>                                
                            </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose> 
                </xsl:if>
            </xsl:for-each>                        
        </xsl:variable>
 
        <!-- When result is false -->
        <xsl:if test="$def_result = 'false' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">                
                <xsl:variable name="CheckSoftwareInstalled">
                    
                    <xsl:variable name="unknownFlag">
                        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'variable' ]">
                            <xsl:variable name="test" select="@id"/>          
                            <xsl:if test="not($TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item)">
                                <xsl:text>2</xsl:text>
                            </xsl:if>
                            <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[  @result = 'does not exist'  or  @result='not evaluated' or  @result='unknown' ] ">
                                <xsl:text>2</xsl:text>                                                                                             
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:variable>

                    <xsl:if test="$unknownFlag!='2'">
                        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry'  ]">
                            <xsl:variable name="test" select="@id"/>
                            <xsl:variable name="res" select="@test_result"/>
                            <xsl:if test="$res='false'">
                                <xsl:text>3</xsl:text>
                            </xsl:if>
                            <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false'  or @result = 'error' or @result = 'not evaluated']">
                                <xsl:text>1</xsl:text>
                            </xsl:for-each>
                        </xsl:for-each>
                        
                        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                            <xsl:variable name="test" select="@id"/>   
                            <xsl:variable name="res" select="@test_result"/>
                            <xsl:if test="$res='false'">
                                <xsl:text>3</xsl:text>
                            </xsl:if>
                            <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                                <xsl:text>1</xsl:text>                                                                                             
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:variable>
                
                <!-- Software installation detection -->
                <xsl:choose>
                     <xsl:when test="not(contains($CheckSoftwareInstalled,'1')) or contains($CheckSoftwareInstalled,'2') or contains($CheckSoftwareInstalled,'3')">
                        <finding messageId="com.mcafee.pa.msg.winsecsoftwaredatagenotexist" isViolation="true">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue>
                        </finding>
                    </xsl:when>

                    <xsl:otherwise>
                        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[position() = $critCount ]">                            
                            <xsl:choose> 
                                <!-- When test type is variable -->
                                <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'variable']">                                    
                                    <xsl:variable name="test" select="@id"/>
                                    <xsl:variable name="variableObjectRef" select="@variableObjectRef"/>            
                                    <xsl:variable name="datatype" select="@datatype"/>
                                    <xsl:variable name="operation" select="@operation"/>                                    
                                    <xsl:variable name="expectedDATage" 
                                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $external_variable_id]"/>                                    
                                    
                                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">                                        
                                        <xsl:variable name="itemRef" select="@item_id"/>
                                        <xsl:variable name="result" select="@result"/>                                      
                                       
                                        <xsl:variable name="actualDATage" 
                                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $variableObjectRef]"/>                                        
                                        <xsl:variable name="actualDATageStatus" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-ind:name/@status"/>
                                        <!-- Findings message -->
                                        <xsl:variable name="message_id">
                                            <xsl:choose>
                                                <xsl:when test="$actualDATageStatus = 'does not exist' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagenotexist</xsl:text>                                    
                                                </xsl:when>
                                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagereaderror</xsl:text>                                    
                                                </xsl:when>                                
                                                <xsl:otherwise>
                                                    <xsl:choose>
                                                        <xsl:when test="$operation = 'less than or equal' ">
                                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                                        </xsl:otherwise>
                                                    </xsl:choose>                                   
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:variable>
                                        
                                        <xsl:variable name="expDays">
                                            <xsl:value-of select="round(number($expectedDATage) div  number( 60 * 60 * 24 ))"/>
                                        </xsl:variable>
                                        
                                        <xsl:variable name="actDays">
                                            <xsl:value-of select="round(number($actualDATage) div  number( 60 * 60 * 24 ))"/>
                                        </xsl:variable>
                                        
                                        <!-- Findings value to be shown in  message -->
                                        <finding messageId="{$message_id}" isViolation="true">
                                            <instanceValue key="software">
                                                <xsl:value-of select="$software"/>                                                    
                                            </instanceValue>    
                                            <instanceValue key="expectedDATage">
                                                <xsl:value-of select="$expectedDATage"/>                                                    
                                            </instanceValue>                       
                                            <instanceValue key="expDATageDays">
                                                <xsl:value-of select="$expDays"/>                       
                                            </instanceValue>
                                            
                                            <instanceValue key="actualDATageDays">
                                                <xsl:value-of select="$actDays"/>                                                    
                                            </instanceValue>
                                            <actualValue key="actualDATage">
                                                <xsl:value-of select="$actualDATage"/>                                                    
                                            </actualValue>
                                        </finding>
                                    </xsl:for-each>
                                    
                                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">                                        
                                        <xsl:variable name="itemRef" select="@item_id"/>
                                        <xsl:variable name="result" select="@result"/>                                        
                                        <xsl:variable name="actualDATage" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-res:value"/>                                        
                                        <xsl:variable name="actualDATageStatus" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-ind:name/@status"/>
                                       <!-- Findings messages -->
                                        <xsl:variable name="message_id">
                                            <xsl:choose>           
                                                <xsl:when test="$operation = 'less than or equal' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                                </xsl:otherwise>
                                            </xsl:choose>                                  
                                        </xsl:variable>
                                        
                                        <xsl:variable name="expDays">
                                            <xsl:value-of select="round(number($expectedDATage) div  number( 60 * 60 * 24 ))"/>
                                        </xsl:variable>
                                        
                                        <xsl:variable name="actDays">
                                            <xsl:value-of select="round(number($actualDATage) div  number( 60 * 60 * 24 ))"/>
                                        </xsl:variable>
                                        <!-- Findings value to be shown in  message -->
                                        <finding messageId="{$message_id}" isViolation="true">
                                            <instanceValue key="software">
                                                <xsl:value-of select="$software"/>                                                    
                                            </instanceValue> 
                                            <instanceValue key="expectedDATage">
                                                <xsl:value-of select="$expectedDATage"/>                                                    
                                            </instanceValue>              
                                            <instanceValue key="expDATageDays">
                                                <xsl:value-of select="$expDays"/>                       
                                            </instanceValue>
                                            
                                            <instanceValue key="actualDATageDays">
                                                <xsl:value-of select="$actDays"/>                                                    
                                            </instanceValue>
                                            <actualValue key="actualDATage">
                                                <xsl:value-of select="$actualDATage"/>                                                    
                                            </actualValue>
                                        </finding>
                                    </xsl:for-each>                                    
                                </xsl:when>
                                <!-- When test type is file -->
                                <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file']">
                                    
                                    <xsl:variable name="test" select="@id"/>
                                    <xsl:variable name="versionnode" select="@versionnode"/>
                                    <xsl:variable name="operation" select="@operation"/>
                                    <xsl:variable name="datatype" select="@datatype"/>                                  
                                    <xsl:variable name="expectedDATage" 
                                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $external_variable_id]"/>                                 
                                    
                                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">                                        
                                        <xsl:variable name="itemRef" select="@item_id"/>
                                        <xsl:variable name="result" select="@result"/>                                        
                                        <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                                        <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                                        <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                                        <!-- Product version -->
                                        <xsl:variable name="version">
                                            <xsl:choose>
                                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                                </xsl:when>
                                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                                </xsl:when>
                                            </xsl:choose>
                                        </xsl:variable>
                                        <!--Product version status -->
                                        <xsl:variable name="versionStatus">
                                            <xsl:choose>
                                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                                                </xsl:when>
                                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                                                </xsl:when>
                                            </xsl:choose>                            
                                        </xsl:variable>
                                        <!-- Findings message -->
                                        <xsl:variable name="message_id">
                                            <xsl:choose>
                                                <xsl:when test="$fileStatus = 'does not exist' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwarefilenotexist</xsl:text>                                    
                                                </xsl:when>
                                                <xsl:when test="$versionStatus = 'does not exist' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwarefileversionnotexist</xsl:text>                                    
                                                </xsl:when>
                                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwarefileversionreaderror</xsl:text>                                    
                                                </xsl:when>                                
                                                <xsl:otherwise>
                                                    <xsl:choose>
                                                        <xsl:when test="$operation = 'less than or equal' ">
                                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                                        </xsl:otherwise>
                                                    </xsl:choose>                                   
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:variable>
                                        <!-- Findings Value to be shown in  message -->
                                        <finding messageId="{$message_id}" isViolation="true">
                                            <instanceValue key="software">
                                                <xsl:value-of select="$software"/>                                                    
                                            </instanceValue>   
                                            <instanceValue key="expectedDATage">
                                                <xsl:value-of select="$expectedDATage"/>                                                    
                                            </instanceValue>
                                            <instanceValue key="filename">
                                                <xsl:value-of select="$file"/>                                                    
                                            </instanceValue> 
                                            <actualValue key="actualDATage">
                                                <xsl:value-of select="$version"/>                                                    
                                            </actualValue>
                                        </finding>
                                        
                                    </xsl:for-each>
                                </xsl:when>
 
                               <!-- When test type is registry -->
                                <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry']">                                    
                                    <xsl:variable name="test" select="@id"/>
                                    <xsl:variable name="key" select="@key"/>
                                    <xsl:variable name="name" select="@name"/>                   
                                    <xsl:variable name="datatype" select="@datatype"/>
                                    <xsl:variable name="operation" select="@operation"/>                                   
                                    <xsl:variable name="expectedDATage" 
                                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $external_variable_id]"/>                                   
                                    
                                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">                                        
                                        <xsl:variable name="itemRef" select="@item_id"/>
                                        <xsl:variable name="result" select="@result"/>                                        
                                        <xsl:variable name="actualDATage" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                                        <xsl:variable name="actualDATageStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                                        <!-- Findings message -->
                                        <xsl:variable name="message_id">
                                            <xsl:choose>
                                                <xsl:when test="$actualDATageStatus = 'does not exist' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagenotexist</xsl:text>                                    
                                                </xsl:when>
                                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagereaderror</xsl:text>                                    
                                                </xsl:when>                                
                                                <xsl:otherwise>
                                                    <xsl:choose>
                                                        <xsl:when test="$operation = 'less than or equal' ">
                                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                                        </xsl:otherwise>
                                                    </xsl:choose>                                   
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:variable>
                                        
                                        <xsl:variable name="expDays">
                                            <xsl:value-of select="round(number($expectedDATage) div  number( 60 * 60 * 24 ))"/>
                                        </xsl:variable>
                                        
                                        <xsl:variable name="actDays">
                                            <xsl:value-of select="round(number($actualDATage) div  number( 60 * 60 * 24 ))"/>
                                        </xsl:variable>
                                        
                                        <!-- Findings value to be shown in  message -->
                                        <finding messageId="{$message_id}" isViolation="true">
                                            <instanceValue key="software">
                                                <xsl:value-of select="$software"/>                                                    
                                            </instanceValue>    
                                            <instanceValue key="expectedDATage">
                                                <xsl:value-of select="$expectedDATage"/>                                                    
                                            </instanceValue>
                                            <instanceValue key="registry">
                                                <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                                            </instanceValue> 
                                            
                                            <instanceValue key="expDATageDays">
                                                <xsl:value-of select="$expDays"/>                       
                                            </instanceValue>
                                            
                                            <instanceValue key="actualDATageDays">
                                                <xsl:value-of select="$actDays"/>                                                    
                                            </instanceValue>
                                            
                                            <actualValue key="actualDATage">
                                                <xsl:value-of select="$actualDATage"/>                                                    
                                            </actualValue>
                                        </finding>
 
                                    </xsl:for-each>
                                </xsl:when>   
	             </xsl:choose>
                        </xsl:for-each>
                    </xsl:otherwise>
					
                </xsl:choose>               
             </findings>
        </xsl:if> 
        
        <!-- When Result is true -->
        <xsl:if test="$def_result = 'true' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">              

                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[position() = $critCount ]">                    
                    <xsl:choose>                        
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'variable'  ]">
                            <xsl:variable name="test" select="@id"/>
                            <xsl:variable name="variableObjectRef" select="@variableObjectRef"/>               
                            <xsl:variable name="datatype" select="@datatype"/>
                            <xsl:variable name="operation" select="@operation"/>                           
                            <xsl:variable name="expectedDATage" 
                                select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $external_variable_id]"/>                          
                            
                            <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">                                
                                <xsl:variable name="itemRef" select="@item_id"/>
                                <xsl:variable name="result" select="@result"/>                                
                                <xsl:variable name="actualDATage" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $variableObjectRef]"/>                                
                                <xsl:variable name="actualDATageStatus" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-ind:name/@status"/>
                                <!-- Findings value to be shown in  message -->
                                <xsl:variable name="message_id">
                                    <xsl:choose>           
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                  
                                </xsl:variable>
                                
                                <xsl:variable name="expDays">
                                    <xsl:value-of select="round(number($expectedDATage) div  number( 60 * 60 * 24 ))"/>
                                </xsl:variable>
                                
                                <xsl:variable name="actDays">
                                    <xsl:value-of select="round(number($actualDATage) div  number( 60 * 60 * 24 ))"/>
                                </xsl:variable>
                                
                                <!-- Findings message -->
                                <finding messageId="{$message_id}" isViolation="false">
                                    <instanceValue key="software">
                                        <xsl:value-of select="$software"/>                                                    
                                    </instanceValue> 
                                    <instanceValue key="expectedDATage">
                                        <xsl:value-of select="$expectedDATage"/>                       
                                    </instanceValue>
                                    <instanceValue key="expDATageDays">
                                        <xsl:value-of select="$expDays"/>                       
                                    </instanceValue>
                                    <actualValue key="actualDATage">
                                        <xsl:value-of select="$actualDATage"/>                                                    
                                    </actualValue>
                                    <instanceValue key="actualDATageDays">
                                        <xsl:value-of select="$actDays"/>                                                    
                                    </instanceValue>
                                </finding>
                            </xsl:for-each>                               
                        </xsl:when>
 
                        <!-- For File test type -->
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                            <xsl:variable name="test" select="@id"/>
                            <xsl:variable name="versionnode" select="@versionnode"/>
                            <xsl:variable name="operation" select="@operation"/>
                            <xsl:variable name="datatype" select="@datatype"/>
                            
                            
                            <xsl:variable name="expectedDATage" 
                                select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $external_variable_id]"/>                           
                            
                            <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">                                
                                <xsl:variable name="itemRef" select="@item_id"/>
                                <xsl:variable name="result" select="@result"/>                                
                                <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                                <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                                <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                                <!-- Product version -->
                                <xsl:variable name="version">
                                    <xsl:choose>
                                        <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                            <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                        </xsl:when>
                                        <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                            <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                        </xsl:when>
                                    </xsl:choose>
                                </xsl:variable>
                                <!-- Product version status -->
                                <xsl:variable name="versionStatus">
                                    <xsl:choose>
                                        <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                            <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                                        </xsl:when>
                                        <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                            <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                                        </xsl:when>
                                    </xsl:choose>                            
                                </xsl:variable>
                                <!-- Findings value to be shown in  message -->
                                <xsl:variable name="message_id">
                                    <xsl:choose>
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                  
                                </xsl:variable>
                                
                                <xsl:variable name="expDays">
                                    <xsl:value-of select="round(number($expectedDATage) div  number( 60 * 60 * 24 ))"/>
                                </xsl:variable>
                                
                                <!-- Findings message -->
                                <finding messageId="{$message_id}" isViolation="false">
                                    <instanceValue key="software">
                                        <xsl:value-of select="$software"/>                                                    
                                    </instanceValue>   
                                    <instanceValue key="expectedDATage">
                                        <xsl:value-of select="$expectedDATage"/>                                                    
                                    </instanceValue>
                                    
                                    <instanceValue key="expDATageDays">
                                        <xsl:value-of select="$expDays"/>                       
                                    </instanceValue>
                                    
                                    <instanceValue key="filename">
                                        <xsl:value-of select="$path"/><xsl:text>\</xsl:text><xsl:value-of select="$file"/>                                                    
                                    </instanceValue> 
                                    <actualValue key="actualDATage">
                                        <xsl:value-of select="$version"/>                                                    
                                    </actualValue>
                                </finding>
                                
                            </xsl:for-each>
                        </xsl:when>
 
                        <!-- For Registry test type -->
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry']">
                            <xsl:variable name="test" select="@id"/>
                            <xsl:variable name="key" select="@key"/>
                            <xsl:variable name="name" select="@name"/>                   
                            <xsl:variable name="datatype" select="@datatype"/>
                            <xsl:variable name="operation" select="@operation"/>
                            <xsl:variable name="expectedDATage" 
                                select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $external_variable_id]"/>
                            <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">        
                                <xsl:variable name="itemRef" select="@item_id"/>
                                <xsl:variable name="result" select="@result"/>
                                <xsl:variable name="actualDATage" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                                <xsl:variable name="actualDATageStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                                <!-- Findings message -->
                                <xsl:variable name="message_id">
                                    <xsl:choose>           
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagesetting</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.winsecsoftwaredatagevalue</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                  
                                </xsl:variable>
                                
                                <xsl:variable name="expDays">
                                    <xsl:value-of select="round(number($expectedDATage) div  number( 60 * 60 * 24 ))"/>
                                </xsl:variable>
                                
                                <xsl:variable name="actDays">
                                    <xsl:value-of select="round(number($actualDATage) div  number( 60 * 60 * 24 ))"/>
                                </xsl:variable>
                                
                                <!-- Findings value to be shown in  message -->
                                <finding messageId="{$message_id}" isViolation="false">
                                    <instanceValue key="software">
                                        <xsl:value-of select="$software"/>                                                    
                                    </instanceValue> 
                                    <instanceValue key="expectedDATage">
                                        <xsl:value-of select="$expectedDATage"/>        
                                    </instanceValue>
                                    <instanceValue key="expDATageDays">
                                        <xsl:value-of select="$expDays"/>                       
                                    </instanceValue>
                                    <instanceValue key="registry">
                                        <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                                    </instanceValue>                            
                                    <actualValue key="actualDATage">
                                        <xsl:value-of select="$actualDATage"/>                                                    
                                    </actualValue>
                                    <instanceValue key="actualDATageDays">
                                        <xsl:value-of select="$actDays"/>                                                    
                                    </instanceValue>
                                </finding>
  
                            </xsl:for-each>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
 
            </findings>
 
          </xsl:if>
    </xsl:template>

</xsl:stylesheet>