<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template name="combinePaths">
        <xsl:param name="first" />
        <xsl:param name="second"/>
        <xsl:variable name="delimiter">
            <xsl:choose>
                <xsl:when test="substring($first,1,1)='/'">/</xsl:when>
                <xsl:otherwise>\</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="strLen" select="string-length($first)"></xsl:variable>
        <xsl:value-of select="$first"/>
        <xsl:if test="not(substring($first, $strLen, 1)=$delimiter)"><xsl:value-of select="$delimiter"/></xsl:if>
        <xsl:value-of select="$second"/>
    </xsl:template>
    
    <xsl:template name="writePerms">
        <xsl:param name="read"/>
        <xsl:param name="write"/>
        <xsl:param name="exec"/>
        <xsl:variable name="bread" select="$read='1' or $read='true'"/>
        <xsl:variable name="bwrite" select="$write='1' or $write='true'"/>
        <xsl:variable name="bexec" select="$exec='1' or $exec='true'"/>
        <xsl:value-of select="(number($bread) * 4) + (number($bwrite) * 2) + number($bexec)"/>
    </xsl:template>
    
</xsl:stylesheet>
